import { useQueryState } from "nuqs";
import { createSearchParamsCache, createParser } from "nuqs/server"
import { decodeFromBinary, encodeToBinary } from "../lib/encoding";
import { WorkflowOption, WorkflowTag } from "@/types/workflow";
import { useCallback } from "react";

const WORKFLOWS_QUERY_KEY = 'm'

const DEFAULT_FILTER_PARSER = createParser<WorkflowOption>({
  parse(value) {
    if (value !== '' && !value) {
      return;
    }

    const decoded = decodeFromBinary(value)
    const parsed = JSON.parse(decoded)
    return parsed
  },
  serialize(value) {
    if (!value) {
      return '';
    }

    return `${encodeToBinary(JSON.stringify(value))}`
  },
  // eq(a, b) {
  //   const e = a === b ||
  //     a?.layers === b?.layers ||
  //     (a?.layers?.sort().join(DEFAULT_FILTER_DELIMITER) === b?.layers?.sort().join(DEFAULT_FILTER_DELIMITER))
  //
  //   return e
  // }
}).withOptions({
  scroll: false,
})

export const servicesWorkflowCache = createSearchParamsCache({
  [WORKFLOWS_QUERY_KEY]: DEFAULT_FILTER_PARSER
})

export function useApplicationWorkflow(filter?: WorkflowTag) {
  const [workflow, setWorkflow] = useQueryState(
    WORKFLOWS_QUERY_KEY,
    DEFAULT_FILTER_PARSER
  )

  const resetWorkflow = useCallback(() => {
    setWorkflow(null)
  }, [setWorkflow])

  return {
    resetWorkflow: resetWorkflow,
    workflow: !!filter && filter !== workflow?.__tag ? undefined : workflow,
    setWorkflow: setWorkflow,
  }
}

